let t_cred;
document.addEventListener('DOMContentLoaded', function(){
    //DataTables Creditos Compras - Ajax
    t_cred = $('#t_creditos').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + 'creditocompras/listar',
            "dataSrc": ""
        },
        "columns": [{
                "data": "id"
            },
            {
                "data": "monto"
            },
            {
                "data": "nombre"
            },
            {
                "data": "fecha"
            },
            {
                "data": "abonado"
            },
            {
                "data": "restante"
            },
            {
                "data": "estado"
            },
            {
                "data": "acciones"
            }
        ],
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [7, "desc"]
        ]
    });

    $('#min').change(function (e) {
        t_cred.draw();
    });
    //Busqueda por Rango de Fechas DataTables - Hasta
    $('#max').change(function (e) {
        t_cred.draw();
    }); 
})
//credito compras
function nuevo_Abono(id) {
    document.getElementById('formulario').reset();
    const http = new XMLHttpRequest();
    const url = base_url + 'creditocompras/abonar/' + id;
    http.open("GET", url);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {            
            const res = JSON.parse(this.responseText);
            document.getElementById('proveedor').value = res.nombre;
            document.getElementById('id').value = res.id;
            document.getElementById('id_proveedor').value = res.id_proveedor;
            document.getElementById('monto_total').value = res.monto;
            document.getElementById('abonado').value = res.abonado;
            document.getElementById('restante').value = parseFloat(res.monto - res.abonado);
            document.getElementById('monto').value = res.restante;
            document.getElementById('monto').focus();
            $('#nuevo_abono').modal('show');
        }
    }
}

function registrarAbono(e) {
    e.preventDefault();
    const restante = parseFloat(document.getElementById('restante').value);
    const abono = parseFloat(document.getElementById('monto').value);
    if (restante >= abono) {
        const http = new XMLHttpRequest();
        const frm = document.getElementById("formulario");
        const url = base_url + 'creditocompras/registrarAbono';
        http.open("POST", url);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                $("#nuevo_abono").modal("hide");
                alertas(res.msg, res.icono);
                if (res.icono == 'success') {
                    t_cred.ajax.reload();
                    setTimeout(() => {
                        window.open(base_url + 'creditocompras/pdfAbono/' + res.id, '_blank');
                    }, 1500);
                }
                
            }
        }
    }else{
        alertas('El monto debe ser menor o igual a la dueda', 'warning');
    }
}