<?php
class Vendedores extends Controller
{
    private $id_usuario;
    public function __construct()
    {
        parent::__construct();
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        $this->id_usuario = $_SESSION['id_usuario'];
    }

    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'pages/vendedores.js'),
        );
        $this->views->getView('vendedores', "index", $data);
    }

    public function listar()
    {
   
        $data = $this->model->getVendedores();
        
        for ($i = 0; $i < count($data); $i++) {
            $data[$i]['editar'] = '';
            if ($data[$i]['estado'] == 1) {
                $data[$i]['editar'] = '<button class="btn btn-primary" type="button" onclick="btnEditarCli(' . $data[$i]['id'] . ');"><i class="fas fa-edit"></i></button>';
                $data[$i]['eliminar'] = '<button class="btn btn-danger" type="button" onclick="btnEliminarCli(' . $data[$i]['id'] . ');"><i class="fas fa-trash-alt"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-success">Activo</span>';
                $data[$i]['estado_txt'] = 'activo';
            } else {
                $data[$i]['eliminar'] = '<button class="btn btn-success" type="button" onclick="btnReingresarCli(' . $data[$i]['id'] . ');"><i class="fas fa-circle"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-danger">Inactivo</span>';
                $data[$i]['estado_txt'] = 'inactivo';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

   
    public function editarAnotaciones()
    {
        $id = strClean($_POST['id']);
        $observaciones = $_POST['observaciones'];
        
        $data = $this->model->modificarAnotaciones($observaciones, $id);

        if ($data == "modificado") {
            $msg = array('msg' => 'Anotación modificada con exito', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al modificar la anotación', 'icono' => 'error');
        }

        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function registrar()
    {
        $nombre = strClean($_POST['nombre']);
        $telefono = strClean($_POST['telefono']);
        $mensajeria = strClean($_POST['mensajeria']);
        $tipoid = strClean($_POST['tipoid']);                
        $nit = strClean($_POST['nit']);        
        $direccion = strClean($_POST['direccion']);
        $municipio = strClean($_POST['municipio']);
        $departamento = strClean($_POST['departamento']);
        $pais = strClean($_POST['pais']);
        $coordenadas = strClean($_POST['coordenadas']);

        $limite_credito = strClean($_POST['limite_credito']);
        $dias_credito = strClean($_POST['dias_credito']);
        $id_vendedor1 = strClean($_POST['id_vendedor1']);
        $tipocliente = strClean($_POST['tipocliente']);

        $contacto = strClean($_POST['contacto']);
        $telcontacto = strClean($_POST['telcontacto']);
        
        $observaciones = $_POST['observaciones'];


        $id = strClean($_POST['id']);
        if (empty($nombre) || empty($telefono) || empty($direccion)) {
            $msg = array('msg' => 'Todo los campos son obligatorios', 'icono' => 'error');
        } else {
            if ($id == "") {
                $data = $this->model->registrarCliente($nombre, $tipoid, $nit, $telefono, $mensajeria, $direccion, $municipio, $departamento, $pais, $coordenadas, $limite_credito, $dias_credito, $id_vendedor1, $tipocliente, $contacto, $telcontacto, $observaciones);
                if ($data == "ok") {
                    $msg = array('msg' => 'Cliente registrado', 'icono' => 'success');
                } else if ($data == "existe") {
                    $msg = array('msg' => 'El cliente ya existe', 'icono' => 'warning');
                } else {
                    $msg = array('msg' => 'Error al registrar el cliente', 'icono' => 'error');
                }
            } else {
                $data = $this->model->modificarCliente($nombre, $tipoid, $nit, $telefono,$mensajeria, $direccion, $municipio, $departamento, $pais, $coordenadas, $limite_credito, $dias_credito, $id_vendedor1, $tipocliente, $contacto, $telcontacto, $observaciones, $id);
                if ($data == "modificado") {
                    $msg = array('msg' => 'Cliente modificado con éxito', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al modificar el cliente', 'icono' => 'error');
                }
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function insertar()
    {
        $data['vendedores']=$this->model->getVendedores();
        $data['paises']=$this->model->getPaises();
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function editar(int $id)
    {
        $data = $this->model->editarCli($id);

        $data['vendedores']=$this->model->getVendedores();
        $data['paises']=$this->model->getPaises();
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function generarReporteEstadoCuenta($id)
    {
        $data['cliente'] = $this->model->editarCli($id);
        $data['empresa'] = $this->model->getEmpresa();
        $data['detalle'] = $this->model->getReporteEstadoCuenta($id);
        
        ob_start();
        $html = $this->views->getView('vendedores', "reporteestadocuenta", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf();
        if ($data['compra']['estado'] == 0) {
            $mpdf->SetWatermarkImage('Assets/img/anulado.png');
            $mpdf->showWatermarkImage = true;
        }

        $mpdf = new \Mpdf\Mpdf([]);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }
    
    public function generarReporteAntiguedadSaldos($id)
    {
        $data['vendedor'] = $this->model->getVendedor($id);
        $data['empresa'] = $this->model->getEmpresa();
        $data['detalle'] = $this->model->getReporteAntiguedadSaldos($id);

        ob_start();
        $html = $this->views->getView('vendedores', "reporteantiguedadsaldos", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';

        $mpdf = new \Mpdf\Mpdf([]);
        $mpdf->WriteHTML($html);
        $mpdf->Output('Antiguedad_saldos_vendedor.pdf', 'I');
    }

    public function generarReporteCuentasCobrar($id)
    {
        $data['vendedor'] = $this->model->getVendedor($id);
        $data['empresa'] = $this->model->getEmpresa();
        $data['detalle'] = $this->model->getReporteCuentasCobrar($id);

        ob_start();
        $html = $this->views->getView('vendedores', "reportecuentascobrar", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';

        $mpdf = new \Mpdf\Mpdf([]);
        $mpdf->WriteHTML($html);
        $mpdf->Output('Cuentas_cobrar_vendedor.pdf', 'I');
    }
       

    public function eliminar(int $id)
    {
        $data = $this->model->accionCli(0, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Cliente dado de baja', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar el cliente', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    
    public function reingresar(int $id)
    {
        $data = $this->model->accionCli(1, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Cliente reingresado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al reingresar el cliente', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function buscarVendedor()
    {
        $data = $this->model->buscarCliente($_GET['q']);
        $datos = array();
        foreach ($data as $row) {
            $data['id'] = $row['id'];
            $data['label'] = $row['nombre'] . ' - ' . $row['direccion'];
            $data['value'] = $row['nombre'];
            $data['vendedor'] = $row['id_vendedor1'];
            $data['tipoid'] = $row['tipoid'];
            $data['nit'] = $row['nit'];         
            $data['direccion'] = $row['direccion'];
            array_push($datos, $data);
        }
        echo json_encode($datos, JSON_UNESCAPED_UNICODE);
        die();
    }
}
