<?php include "Views/templates/header.php"; ?>

<button class="btn btn-primary mb-2" type="button" onclick="frmUsuario();"><i class="fas fa-plus"></i></button>

<div class="card shadow-lg">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped display responsive nowrap" id="table_user" style="width: 100%;">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Usuario</th>
                        <th>Correo</th>
                        <th>Nombre</th>
                        <th>Estado</th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div id="nuevo_usuario" class="modal fade" role="dialog" aria-labelledby="my-modal-title" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <h5 class="modal-title text-white" id="title">Nuevo Usuario</h5>
                <button class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="formulario" class="needs-validation" novalidate autocomplete="off">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="nombre">Nombre Completo <strong class="text-danger">*</strong></label>
                                <input type="hidden" id="id" name="id">
                                <input id="nombre" class="form-control" type="text" name="nombre" placeholder="Nombre del usuario" required>
                                <div class="valid-feedback">
                                    Correcto
                                </div>
                                <div class="invalid-feedback">
                                    El nombre es requerido
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="usuario">Usuario <strong class="text-danger">*</strong></label>
                                <input id="usuario" class="form-control" type="text" name="usuario" placeholder="Usuario" required>
                                <div class="valid-feedback">
                                    Correcto
                                </div>
                                <div class="invalid-feedback">
                                    El usuario es requerido
                                </div>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="correo">Correo <strong class="text-danger">*</strong></label>
                                <input id="correo" class="form-control" type="email" name="correo" placeholder="Correo electrónico" required>
                                <div class="valid-feedback">
                                    Correcto
                                </div>
                                <div class="invalid-feedback">
                                    El correo es requerido
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6" id="container-clave">
                            <div class="form-group">
                                <label for="clave">Contraseña <strong class="text-danger">*</strong></label>
                                <input id="clave" class="form-control" type="password" name="clave" placeholder="Contraseña" required>
                                <div class="valid-feedback">
                                    Correcto
                                </div>
                                <div class="invalid-feedback">
                                    La contraseña es requerido
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6" id="container-confirmar">
                            <div class="form-group">
                                <label for="confirmar">Confirmar Contraseña <strong class="text-danger">*</strong></label>
                                <input id="confirmar" class="form-control" type="password" name="confirmar" placeholder="Confirmar contraseña" required>
                                <div class="valid-feedback">
                                    Correcto
                                </div>
                                <div class="invalid-feedback">
                                    Confirmar clave es requerido
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="caja">Caja</label>
                                <select id="caja" class="form-control" name="caja" required>
                                    <option value="">Seleccionar</option>
                                    <?php foreach ($data['cajas'] as $row) { ?>
                                        <option value="<?php echo $row['id']; ?>"><?php echo $row['caja']; ?></option>
                                    <?php } ?>
                                </select>
                                <div class="valid-feedback">
                                    Correcto
                                </div>
                                <div class="invalid-feedback">
                                    La caja es requerido
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" type="submit" id="btnAccion">Registrar</button>
                    <button class="btn btn-danger" type="button" data-dismiss="modal">Cancelar</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php include "Views/templates/footer.php"; ?>