<?php

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;

class Reportes extends Controller
{
    private $usuario, $ruta;
    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->usuario = $_SESSION['id_usuario'];
    }
    public function reportes_pdf(string $url)
    {
        $this->ruta = $url;
        if (!empty($this->ruta)) {
            $data['empresa'] = $this->model->getEmpresa();
            if ($this->ruta === "ayer") {
                $data['productos'] = $this->model->getReporteAyer($this->usuario);
            } else if ($this->ruta === "actual") {
                $data['productos'] = $this->model->getReporteDia($this->usuario);
            } else if ($this->ruta === "semana") {
                $data['productos'] = $this->model->getReporteSemana($this->usuario);
            } else if ($this->ruta === "mes") {
                $data['productos'] = $this->model->getReporteMes($this->usuario);
            } else if ($this->ruta === "mes_anterior") {
                $data['productos'] = $this->model->getReporteMesAnterior($this->usuario);
            } else if ($this->ruta === "mes_actual") {
                $data['productos'] = $this->model->getReporteMesActual($this->usuario);
            } else {
                echo "Pagina no encontrada";
                exit;
            }
            ob_start();
            $html = $this->views->getView('reportes', "pdf", $data);
            $html = ob_get_clean();
            require_once 'vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf();
            $mpdf->SetWatermarkImage('Assets/img/logo.png');
            $mpdf->showWatermarkImage = true;
            // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
            $mpdf->WriteHTML($html);
            $mpdf->Output();
        } else {
            echo 'Error';
            exit;
        }
    }
    public function reportes_excel(string $url)
    {
        $this->ruta = $url;
        if (!empty($this->ruta)) {
            if ($this->ruta === "ayer") {
                $productos = $this->model->getReporteAyer($this->usuario);
            } else if ($this->ruta === "actual") {
                $productos = $this->model->getReporteDia($this->usuario);
            } else if ($this->ruta === "semana") {
                $productos = $this->model->getReporteSemana($this->usuario);
            } else if ($this->ruta === "mes") {
                $productos = $this->model->getReporteMes($this->usuario);
            } else if ($this->ruta === "mes_anterior") {
                $productos = $this->model->getReporteMesAnterior($this->usuario);
            } else if ($this->ruta === "mes_actual") {
                $productos = $this->model->getReporteMesActual($this->usuario);
            } else {
                echo "Pagina no encontrada";
                exit;
            }
            if (empty($productos)) {
                echo 'No hay Productos';
                exit;
            }
            require 'vendor/autoload.php';
            $spreassheet = new Spreadsheet();
            $spreassheet->getProperties()->setCreator($_SESSION['usuario'])->setTitle('Reporte de Ventas');
            $spreassheet->setActiveSheetIndex(0);
            $hojaActiva = $spreassheet->getActiveSheet();
            $hojaActiva->getColumnDimension('A')->setWidth(15);
            $hojaActiva->getColumnDimension('B')->setWidth(50);
            $hojaActiva->getColumnDimension('C')->setWidth(15);
            $hojaActiva->getColumnDimension('D')->setWidth(15);
            $hojaActiva->getColumnDimension('E')->setWidth(15);

            $spreassheet->getActiveSheet()->getStyle('A1:E1')->getFill()
                ->setFillType(Fill::FILL_SOLID)
                ->getStartColor()->setARGB('FFFF0000');

            $spreassheet->getActiveSheet()->getStyle('A1:E1')
                ->getFont()->getColor()->setARGB(Color::COLOR_WHITE);

            $hojaActiva->setCellValue('A1', 'Código');
            $hojaActiva->setCellValue('B1', 'Descripción');
            $hojaActiva->setCellValue('C1', 'Cantidad');
            $hojaActiva->setCellValue('D1', 'Precio Venta');
            $hojaActiva->setCellValue('E1', 'Fecha');

            $fila = 2;
            foreach ($productos as $row) {
                $hojaActiva->setCellValue('A' . $fila, $row['codigo']);
                $hojaActiva->setCellValue('B' . $fila, $row['descripcion']);
                if ($row['cantidad'] == 0) {
                    $spreassheet->getActiveSheet()->getStyle('C' . $fila)
                        ->getFont()->getColor()->setARGB(Color::COLOR_RED);
                }
                $hojaActiva->setCellValue('C' . $fila, $row['cantidad']);
                $hojaActiva->setCellValue('D' . $fila, $row['precio_venta']);
                $hojaActiva->setCellValue('E' . $fila, $row['fecha']);
                $fila++;
            }
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="ventas.xlsx"');
            header('Cache-Control: max-age=0');

            $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreassheet, 'Xlsx');
            $writer->save('php://output');
        } else {
            echo 'Error';
            exit;
        }
    }
}
