<?php
class ReportesModel extends Query
{
    public function __construct()
    {
        parent::__construct();
    }
    public function getEmpresa()
    {
        $sql = "SELECT * FROM empresa";
        $data = $this->select($sql);
        return $data;
    }
    //Consulta los datos del día (hoy)
    public function getReporteDia(int $id_usuario)
    {
        $sql = "SELECT v.fecha, 
        SUM(d.cantidad) AS cantidad, 
        d.descuento, 
        p.codigo, 
        p.descripcion, 
        p.precio_venta 
        FROM ventas v 
        INNER JOIN detalle_ventas d ON d.folio = v.id 
        INNER JOIN productos p ON p.id = d.id_producto 
        WHERE TO_DAYS(v.fecha) = TO_DAYS(NOW()) 
        AND v.id_usuario = $id_usuario 
        GROUP BY v.fecha, d.descuento, p.codigo, p.descripcion, p.precio_venta";
        $data = $this->selectAll($sql);
        return $data;
    }
    //Consultar los datos de ayer
    public function getReporteAyer(int $id_usuario)
    {
        $sql = "SELECT 
        v.fecha, 
        SUM(d.cantidad) AS cantidad, 
        d.descuento, 
        p.codigo, 
        p.descripcion, 
        p.precio_venta 
        FROM 
            ventas v 
            INNER JOIN detalle_ventas d ON d.folio = v.id 
            INNER JOIN productos p ON p.id = d.id_producto 
        WHERE 
            DATE(v.fecha) = CURDATE() - INTERVAL 1 DAY 
            AND v.id_usuario = $id_usuario 
        GROUP BY 
            v.fecha, d.descuento, p.codigo, p.descripcion, p.precio_venta";
        $data = $this->selectAll($sql);
        return $data;
    }
    //Consultar los datos de los últimos 7 días (incluyendo hoy un total de 7 días)
    public function getReporteSemana(int $id_usuario)
    {
        $sql = "SELECT 
        v.fecha, 
        SUM(d.cantidad) AS cantidad, 
        d.descuento, 
        p.codigo, 
        p.descripcion, 
        p.precio_venta 
    FROM 
        ventas v 
        INNER JOIN detalle_ventas d ON d.folio = v.id 
        INNER JOIN productos p ON p.id = d.id_producto 
    WHERE 
        DATE_SUB(CURDATE(), INTERVAL 7 DAY) <= DATE(v.fecha) 
        AND v.id_usuario = $id_usuario 
    GROUP BY 
        v.fecha, d.descuento, p.codigo, p.descripcion, p.precio_venta";
        $data = $this->selectAll($sql);
        return $data;
    }
    //Consultar los datos de los últimos 30 días (incluyendo hoy un total de 30 días)
    public function getReporteMes(int $id_usuario)
    {
        $sql = "SELECT 
        v.fecha, 
        SUM(d.cantidad) AS cantidad, 
        d.descuento, 
        p.codigo, 
        p.descripcion, 
        p.precio_venta 
    FROM 
        ventas v 
        INNER JOIN detalle_ventas d ON d.folio = v.id 
        INNER JOIN productos p ON p.id = d.id_producto 
    WHERE 
        DATE_SUB(CURDATE(), INTERVAL 30 DAY) <= DATE(v.fecha) 
        AND v.id_usuario = $id_usuario 
    GROUP BY 
        v.fecha, d.descuento, p.codigo, p.descripcion, p.precio_venta";
        $data = $this->selectAll($sql);
        return $data;
    }
    //Consultar los datos del mes actual (este mes)
    public function getReporteMesActual(int $id_usuario)
    {
        $sql = "SELECT 
        v.fecha, 
        SUM(d.cantidad) AS cantidad, 
        d.descuento, 
        p.codigo, 
        p.descripcion, 
        p.precio_venta 
    FROM 
        ventas v 
        INNER JOIN detalle_ventas d ON d.folio = v.id 
        INNER JOIN productos p ON p.id = d.id_producto 
    WHERE 
        DATE_FORMAT(v.fecha, '%Y%m') = DATE_FORMAT(CURDATE(), '%Y%m') 
        AND v.id_usuario = $id_usuario 
    GROUP BY 
        v.fecha, d.descuento, p.codigo, p.descripcion, p.precio_venta";
        $data = $this->selectAll($sql);
        return $data;
    }
    //Consultar los datos del mes anterior
    public function getReporteMesAnterior(int $id_usuario)
    {
        $sql = "SELECT 
        v.fecha, 
        SUM(d.cantidad) AS cantidad, 
        d.descuento, 
        p.codigo, 
        p.descripcion, 
        p.precio_venta 
    FROM 
        ventas v 
        INNER JOIN detalle_ventas d ON d.folio = v.id 
        INNER JOIN productos p ON p.id = d.id_producto 
    WHERE 
        PERIOD_DIFF(DATE_FORMAT(NOW(), '%Y%m'), DATE_FORMAT(v.fecha, '%Y%m')) = 0 
        AND v.id_usuario = $id_usuario 
    GROUP BY 
        v.fecha, d.descuento, p.codigo, p.descripcion, p.precio_venta";
        $data = $this->selectAll($sql);
        return $data;
    }
}
