let t_cred;
document.addEventListener('DOMContentLoaded', function(){
    //DataTables Creditos Ventas - Ajax
    t_cred = $('#t_creditos').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + "creditoventas/listar",
            "dataSrc": ""
        },
        "columns": [{
                "data": "venta"
            },
            {
                "data": "nombre"
            },
            {
                "data": "fecha"
            },
            {
                "data": "monto"
            },
            {
                "data": "abonado"
            },
            {
                "data": "restante"
            },
            {
                "data": "estado"
            },
            {
                "data": "acciones"
            }
        ],
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "desc"]
        ]
    });

    $('#min').change(function (e) {
        t_cred.draw();
    });
    //Busqueda por Rango de Fechas DataTables - Hasta
    $('#max').change(function (e) {
        t_cred.draw();
    }); 
})

//tipo
//fecha
//observaciones

function nuevo_abono(id) {
    document.getElementById('formulario').reset();

    const tipo = document.getElementById("tipo");
    let optionElement;
    const http = new XMLHttpRequest();
    const url = base_url + "creditoventas/abonar/"+ id;

    http.open("GET", url);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);

            if (Array.isArray(res.metodos)) {
                res.metodos.forEach(function(element) {
                    optionElement = document.createElement("option");
                    optionElement.value = element.codme;
                    optionElement.text = element.nombre;
                    tipo.add(optionElement);
                });
            }
            document.getElementById('cliente').value = res.nombre;
            document.getElementById('id').value = res.id;
            document.getElementById('id_cliente').value = res.id_cliente;
            document.getElementById('monto_total').value = res.monto;
            document.getElementById('abonado').value = res.abonado;
            document.getElementById('restante').value = parseFloat(res.monto - res.abonado);
            document.getElementById('monto').value = res.restante;
            document.getElementById('fecha').value = getCurrentDate();
            document.getElementById('monto').focus();

            $('#nuevo_abono').modal('show');
        }
    }
}

function getCurrentDate()
{
    const currentDate = new Date();
    const year = currentDate.getFullYear();
    let month = currentDate.getMonth() + 1;
    let day = currentDate.getDate();
    if (month < 10) { month = '0' + month; }
    if (day < 10) { day = '0' + day; }
    const formattedDate = `${year}-${month}-${day}`;
    return formattedDate;
}

function registrarAbono(e) {
    e.preventDefault();
    const restante = parseFloat(document.getElementById('restante').value);
    const abono = parseFloat(document.getElementById('monto').value);

    if (restante >= abono) {
        const http = new XMLHttpRequest();
        const frm = document.getElementById("formulario");
        const url = base_url + "creditoventas/registrarAbono";
        http.open("POST", url);
        http.send(new FormData(frm));
        
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                $("#nuevo_abono").modal("hide");
                alertas(res.msg, res.icono);
                if (res.icono == 'success') {
                    t_cred.ajax.reload();
                    setTimeout(() => {
                        window.open(base_url + 'creditoventas/pdfAbono/' + res.id, '_blank');
                    }, 1500);
                }
            }
        }
    } else {
        alertas('El monto debe ser menor o igual a la dueda', 'warning');
    }
}