const btnProcesar = document.getElementById('btnProcesar');
const id_cliente = document.getElementById('id_cliente');
const nombre = document.getElementById('nombre');
const efectivo_recibido = document.getElementById('efectivo_recibido');
const cambio = document.getElementById('cambio');
const anotacion = document.getElementById('anotacion');
const form = document.getElementById('formulario');

const serie = document.getElementById('serie');
const btnClientesHide = document.getElementById('btnClientesHide');
const btnClientesShow = document.getElementById('btnClientesShow');
const areaCliente = document.getElementById('areaCliente');
const areaClienteMinimizado = document.getElementById('areaClienteMinimizado');

const customCheck = document.getElementById("customCheck");
const buscarClienteContainer = document.getElementById("buscarClienteContainer");
const ClienteContainer = document.getElementById("ClienteContainer");
const buscarCliente = document.getElementById("buscarCliente");
const nombreCliente = document.getElementById("nombreCliente");
const vendedores = document.getElementById("vendedores");
const fecha = document.getElementById("fecha");

const tipoid_cliente = document.getElementById('tipoid_cliente');
const nit_cliente = document.getElementById('nit_cliente');
const direccion_cliente = document.getElementById('direccion_cliente');

const tipopago = document.getElementById('tipopago');
const total = document.getElementById('total');

let showCliente=true;
let countAutocomplete=0;

document.addEventListener('DOMContentLoaded', function () {
    cargarDetalle(true)

    //Autocomplete - Jquery UI, Buscar Clientes para la Venta
    $("#buscarCliente").autocomplete({
        minLength: 2,
        source: function (request, response) {
            $.ajax({
                url: base_url + 'clientes/buscarCliente',
                dataType: "json",
                data: {
                    q: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('id_cliente').value = ui.item.id;
            document.getElementById('id_cliente_badge').innerHTML = ui.item.id;
            document.getElementById('tipoid_cliente').value = ui.item.tipoid;
            document.getElementById('nit_cliente').value = ui.item.nit;
            document.getElementById('direccion_cliente').value = ui.item.direccion;
            vendedores.value=ui.item.vendedor;
        },
      
    })

    btnProcesar.addEventListener('click', generarVenta)
    btnClientesHide.addEventListener('click', toggleClientes);
    btnClientesShow.addEventListener('click', toggleClientes);    

    fecha.value = new Date().toISOString().substring(0, 10);

    var forms = document.getElementsByClassName('needs-validation');
    // Loop over them and prevent submission
    var validation = Array.prototype.filter.call(forms, function (form) {
        form.addEventListener('submit', function (event) {
            event.preventDefault();
            if (form.checkValidity() === false) {
                event.stopPropagation();
                form.classList.add('was-validated');
            } else {
                const url = base_url + 'clientes/registrar';
                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.send(new FormData(this));
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);
                        alertas(res.msg, res.icono);
                        if (res.icono == 'success') {
                            $('#nuevo_cliente').modal('hide');
                        }
                    }
                }
            }

        }, false);
    });

})

function toggleClientes()
{
    showCliente=!showCliente;

    if(showCliente===true)
    {
        btnClientesHide.classList.remove("d-none")
        btnClientesShow.classList.add("d-none")
        areaCliente.classList.remove("d-none")
        areaClienteMinimizado.classList.add("d-none")
    } else {
        btnClientesHide.classList.add("d-none")
        btnClientesShow.classList.remove("d-none")
        areaCliente.classList.add("d-none")
        areaClienteMinimizado.classList.remove("d-none")

        let nombre_cliente=(customCheck.checked===true)?nombreCliente.value:buscarCliente.value;
        if(nombre_cliente.toString().trim()=='') nombre_cliente='No seleccionado'

        areaClienteMinimizado.innerHTML=`
            <p class='mb-0'>
            <span class='mr-1'><strong>Cliente:</strong> ${nombre_cliente}</span>
            <span class="badge badge-secondary mr-1">Serie: ${(serie.value=='1')?'AD':'DIVEMOSA'}</span>
            </p>
        `
    }  
}

function frmCliente() {
    document.getElementById('id').value= '';
    document.getElementById('title').textContent = 'Nuevo Cliente';
    document.getElementById('btnAccion').textContent = 'Registrar';
    form.reset();
    $('#nuevo_cliente').modal('show');
}

function ingresarVenta(id_pro) {
    const url = base_url + 'recibos/ingresar/' + id_pro;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {

            const res = JSON.parse(this.responseText);

            cargarDetalle();
            document.getElementById('buscarProducto').value = '';
            document.getElementById('buscarProducto').focus();
            alertas(res.msg, res.icono);
            return false;
        }
    }
}

function cantidadVenta(e, id) {
    const url = base_url + 'recibos/cantidadVenta/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            if (res.icono != 'success') {
                alertas(res.msg, res.icono);
            }
            cargarDetalle();
            return false;
        }
    }
}

function cargarDetalle(loadSelect=false) {

    const url = base_url + 'recibos/listar/detalle_recibos_temp';
    const http = new XMLHttpRequest();
    let select = document.getElementById('serie');
    let option =null;
        
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            let html = '';

            if(loadSelect===true)
            {
                let selectedOption = select.value;
                select.innerHTML = '';          
                res.series.forEach(row => {
                    option = document.createElement('option');
                    option.value = row['iduser'];
                    option.text = `[${row['iduser']}] ${row['user']}`;
                    select.appendChild(option);
                });
                if(idestacion>0)
                {
                    select.value=idestacion;
                    select.disabled=true;                    
                }                
            }

            if(vendedores!==null)
            {
                let selectedOptionVendedores = vendedores.value;
                vendedores.innerHTML = '';          
                res.vendedores.forEach(row => {
                    option = document.createElement('option');
                    option.value = row['codven'];
                    option.text = `[${row['codven']}] ${row['nombre']}`;
                    vendedores.appendChild(option);
                });

                if(selectedOptionVendedores!='') vendedores.value=selectedOptionVendedores;
            }

        }
    }
}

function precioTotal (e,id)
{
    const url = base_url + 'recibos/totalProducto/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {

        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            cargarDetalle();
            alertas(res.msg, res.icono);
        }
    }
}

function precioProducto(e, id) {
    const url = base_url + 'recibos/precioProducto/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            cargarDetalle();
            alertas(res.msg, res.icono);
        }
    }
}

function descuentoVenta(e, id) {
    const url = base_url + 'recibos/descuentoVenta/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            alertas(res.msg, res.icono);
            cargarDetalle();
            return false;
        }
    }
}

function clienteCustom(logic)
{
    buscarCliente.value='';
    nombreCliente.value='';

    document.getElementById('id_cliente').value = 1;
    document.getElementById('id_cliente_badge').innerHTML = '';
    document.getElementById('tipoid_cliente').value = 1;
    document.getElementById('nit_cliente').value = 'CF';
    document.getElementById('direccion_cliente').value = 'GUATEMALA, CIUDAD';

    if(logic===true)
    {
        id_cliente.value=0;
        buscarClienteContainer.classList.add("d-none");
        ClienteContainer.classList.remove("d-none");
    } else {
        id_cliente.value=1;
        buscarClienteContainer.classList.remove("d-none");
        ClienteContainer.classList.add("d-none");
    }
}


function eliminar(id) {
    const url = base_url + 'recibos/delete/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            alertas(res.msg, res.icono);
            cargarDetalle();
        }
    }
}

function generarVenta(e) {
    e.preventDefault();
    btnProcesar.disabled = true;

    Swal.fire({
        title: 'Esta seguro de procesar el Recibo?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {

        if (result.isConfirmed) {

                const url = base_url + 'recibos/generarVenta';
                const data = new FormData();
                data.append('id_cliente', id_cliente.value);
                data.append('serie', serie.value);
                data.append('anotacion', anotacion.value);
                data.append('id_vendedor', vendedores.value);
                data.append('fecha', fecha.value);

                data.append('tipoid', tipoid_cliente.value);
                data.append('nit', nit_cliente.value);
                data.append('direccion', direccion_cliente.value);

                data.append('total', total.value);

                if(customCheck.checked===true) {
                    data.append('nombre_cliente', nombreCliente.value);
                    data.append('mostrador', 1);
                } else {
                    data.append('nombre_cliente', nombreCliente.value);
                    data.append('mostrador', 0);
                }
                const activeValue = getActiveRadioValue('tipopago[]');
                data.append('tipopago', activeValue);

                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.send(data);
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);
                        alertas(res.msg, res.icono);
                        
                        if (typeof res.error !== 'undefined') { btnProcesar.disabled = false; }

                        if (res.folio) {
                            /*let ruta;
                            if (tipoPdf) {
                                ruta = base_url + 'recibos/ticket/' + res.folio;
                            } else {
                                ruta = base_url + 'recibos/generarPdf/' + res.folio;
                            }
                            window.open(ruta);*/
                            setTimeout(() => {
                                window.location.reload();
                            }, 2000);
                        }
                    }
                }

        } else {
            btnProcesar.disabled = false;
        }
    })
}

function getActiveRadioValue(name) {
    const radios = document.getElementsByName(name);
    for (const radio of radios) {
      if (radio.checked) {
        return radio.value;
      }
    }
    return null; // No radio button is selected
}