<?php
class ComprasModel extends Query
{
    public function __construct()
    {
        parent::__construct();
    }
    public function buscarProducto(string $cod)
    {
        $sql = "SELECT * FROM productos WHERE codigo LIKE '%" . $cod . "%' AND estado = 1 OR descripcion LIKE '%" . $cod . "%' AND estado = 1 LIMIT 25";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function buscarProveedor(string $nombre)
    {
        $sql = "SELECT * FROM proveedor WHERE nombre LIKE '%" . $nombre . "%' AND estado = 1 LIMIT 10";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function getProducto(int $id)
    {
        $sql = "SELECT * FROM productos WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function getDatos(string $table, int $id)
    {
        $sql = "SELECT * FROM $table WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function registrarDetalle(int $id_producto, int $id_usuario, string $precio, int $cantidad, string $sub_total)
    {
        $sql = "INSERT INTO detalle(id_producto, id_usuario, precio, cantidad, sub_total) VALUES (?,?,?,?,?)";
        $datos = array($id_producto, $id_usuario, $precio, $cantidad, $sub_total);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function getComprobar(int $id, int $usuario, string $table)
    {
        $sql = "SELECT * FROM $table WHERE id_producto = $id AND id_usuario = $usuario";
        $data = $this->select($sql);
        return $data;
    }
    public function calcularCompra(int $id_usuario, string $table)
    {
        $sql = "SELECT SUM(sub_total) AS total FROM $table WHERE id_usuario = $id_usuario";
        $data = $this->select($sql);
        return $data;
    }
    public function calcularDescuento(int $folio)
    {
        $sql = "SELECT SUM(descuento) AS total FROM detalle_ventas WHERE folio = $folio";
        $data = $this->select($sql);
        return $data;
    }
    public function deleteDetalle(int $id, string $table)
    {
        $sql = "DELETE FROM $table WHERE id = ?";
        $datos = array($id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function insertarCompra(int $id, string $total, int $id_pr, string $fecha, string $hora, int $forma, int $serie, string $anotacion)
    {
        $sql = "INSERT INTO compras (id_usuario, total, id_proveedor, fecha, hora, forma_pago, serie, anotacion) VALUES (?,?,?,?,?,?,?,?)";
        $datos = array($id, $total, $id_pr, $fecha, $hora, $forma, $serie, $anotacion);
        $data = $this->insertar($sql, $datos);
        if ($data > 0) {
            $res = $data;
        } else {
            $res = 0;
        }
        return $res;
    }
    public function insertarCreditoCompra(int $id, string $total, int $id_pr, string $fecha, int $id_usuario)
    {
        $sql = "INSERT INTO creditos_compras (compra, monto, proveedor,fecha, id_usuario) VALUES (?,?,?,?,?)";
        $datos = array($id, $total, $id_pr, $fecha, $id_usuario);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function registrarDetalles(int $id, int $id_pro, string $cantidad, string $descuento, string $precio, string $sub_total)
    {
        $sql = "INSERT INTO detalle_compra (folio, id_producto, cantidad, descuento, precio, sub_total) VALUES (?,?,?,?,?,?)";
        $datos = array($id, $id_pro, $cantidad, $descuento, $precio, $sub_total);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function registrar(string $table,int $id, int $id_pro, string $cantidad, string $descuento, string $precio, string $sub_total)
    {
        $sql = "INSERT INTO $table (folio, id_producto, cantidad, descuento, precio ,sub_total) VALUES (?,?,?,?,?,?)";
        $datos = array($id, $id_pro, $cantidad, $descuento, $precio, $sub_total);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function eliminarTemp(int $id_usuario, string $table)
    {
        $sql = "DELETE FROM $table WHERE id_usuario = ?";
        $datos = array($id_usuario);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $msg = 'ok';
        }else{
            $msg = 'error';
        }
        return $msg;
    }
    public function getEmpresa()
    {
        $sql = "SELECT * FROM empresa";
        $data = $this->select($sql);
        return $data;
    }
    public function getCompras(int $id_usuario)
    {
        $sql = "SELECT p.id, p.nombre, c.* FROM proveedor p INNER JOIN compras c ON c.id_proveedor = p.id WHERE c.id_usuario = $id_usuario";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function getHistorial(string $table, int $id_usuario)
    {
        $sql = "SELECT c.id, c.nombre, v.* FROM clientes c INNER JOIN $table v ON v.id_cliente = c.id WHERE v.id_usuario = $id_usuario";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function detalleCompras(int $folio)
    {
        $sql = "SELECT c.*, d.*, p.cantidad AS stock, p.descripcion FROM compras c INNER JOIN detalle_compra d ON c.id = d.folio INNER JOIN productos p ON p.id = d.id_producto WHERE c.id = $folio";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function getDetalle(int $id, string $table)
    {
        $sql = "SELECT d.*, p.descripcion FROM $table d INNER JOIN productos p ON d.id_producto = p.id WHERE d.id_usuario = $id";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function getSeries()
    {
        $sql = "SELECT iduser, user FROM ws_users ";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function getDetalleCompra(string $table, int $id)
    {
        $sql = "SELECT * FROM $table WHERE folio = $id";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function actualizarStock(int $cantidad, int $id)
    {
        $sql = "UPDATE productos SET cantidad = ? WHERE id = ?";
        $datos = array($cantidad, $id);
        $this->save($sql, $datos);
    }
    public function anular(string $table, int $id)
    {
        $sql = "UPDATE $table SET estado = ? WHERE id = ?";
        $datos = array(0, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function anularCredito(string $table, int $id)
    {
        $sql = "UPDATE $table SET estado = ? WHERE venta = ?";
        $datos = array(2, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    
    public function actualizarCantidad(string $table, string $cant, int $id)
    {
        $sql = "SELECT * FROM $table WHERE id = $id";
        $data = $this->select($sql);
        $sub_total = ($cant * $data['precio']) - $data['descuento'];
        $sql = "UPDATE $table SET cantidad = ?, sub_total = ? WHERE id = ?";
        $datos = array($cant, $sub_total, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }

    public function actualizarPrecio(string $table, string $precio, int $id)
    {
        $sql = "SELECT * FROM $table WHERE id = $id";
        $data = $this->select($sql);
        $sub_total = ($data['cantidad'] * $precio) - $data['descuento'];
        $sql = "UPDATE $table SET precio = ?, sub_total = ? WHERE id = ?";
        $datos = array($precio, $sub_total, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    
    public function actualizarDescuento(string $table, string $desc, int $id)
    {
        $sql = "SELECT * FROM $table WHERE id = $id";
        $data = $this->select($sql);
        $sub_total = ($data['cantidad'] * $data['precio']) - $desc;
        $sql = "UPDATE $table SET descuento = ?, sub_total = ? WHERE id = ?";
        $datos = array($desc, $sub_total ,$id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function getCompra(int $id)
    {
        $sql = "SELECT c.*, p.nombre, p.telefono, p.direccion FROM compras c INNER JOIN proveedor p ON c.id_proveedor = p.id WHERE c.id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function serie(string $table, int $tipo)
    {
        $sql = "SELECT id, tipo, serie FROM $table WHERE tipo = $tipo ORDER BY id DESC LIMIT 1";
        $data = $this->select($sql);
        return $data;
    }
}
