let t_cierre;
document.addEventListener('DOMContentLoaded', function(){
    //DataTables Historial Cajas - Ajax
    t_cierre = $('#t_cierre').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + "cajas/listar_apertura",
            "dataSrc": ""
        },

        "columns": [{
                "data": "id"
            },
            {
                "data": "fecha_apertura"
            },
            {
                "data": "fecha_fin"
            },
            {
                "data": "monto_inicial"
            },
            {
                "data": "monto_fin"
            },
            {
                "data": "total"
            },
            {
                "data": "ventas"
            },
            {
                "data": "estado"
            },
            {
                "data": "reporte"
            }
        ],
        "drawCallback": function () {
            let api = this.api();
            $(api.columns(1).footer()).html(
                'Total:  ' + api.columns(1, {
                    page: 'current'
                }).data().sum()
            )
        },
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "desc"]
        ]
    });
})
//apertura
function frmAbrir() {
    document.getElementById('btnAccion').value = 'Abrir';
    document.getElementById('titleModal').textContent = 'Abrir Caja';
    document.getElementById('modal_cierre').innerHTML = '';
    $('#nuevoCajaCierre').modal('show');
}

function registrarCierre(e) {
    e.preventDefault();
    const monto_inicial  = document.getElementById('monto_inicial').value;
    if (monto_inicial == '') {
        alertas('Ingrese monto Inicial', 'warning');
        return false;
    } else {
        const url = base_url + 'cajas/registrarCierre';
        const frm = document.getElementById('formulario');
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                alertas(res.msg, res.icono);
                t_cierre.ajax.reload();
                frm.reset();
                $('#nuevoCajaCierre').modal('hide');
            }
        }
    }
}