let MyChart;
let t_prest, t_gastos, t_dev;
document.addEventListener('DOMContentLoaded', function(){
    grafico_movimiento()

    //DataTables Prestamos Caja - Ajax
    t_prest = $('#t_prestamos').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + "cajas/listar_prestamos",
            "dataSrc": ""
        },
        "columns": [{
            "data": "id"
        },
        {
            "data": "descripcion"
        },
        {
            "data": "monto"
        },
        {
            "data": "fecha"
        },
        {
            "data": "hora"
        }
        ],
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "desc"]
        ]
    });
    //DataTables Gastos Caja - Ajax
    t_gastos = $('#t_gastos').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + "cajas/listar_gastos",
            "dataSrc": ""
        },
        "columns": [{
            "data": "id"
        },
        {
            "data": "descripcion"
        },
        {
            "data": "monto"
        },
        {
            "data": "fecha"
        },
        {
            "data": "hora"
        }
        ],
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "desc"]
        ]
    });
    //DataTables Devolución Caja - Ajax
    t_dev = $('#t_devolucion').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + "cajas/listar_devolucion",
            "dataSrc": ""
        },
        "columns": [{
            "data": "id"
        },
        {
            "data": "descripcion"
        },
        {
            "data": "monto"
        },
        {
            "data": "fecha"
        },
        {
            "data": "hora"
        }
        ],
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "desc"]
        ]
    });
})
//Movimientos
function frmMovimiento_caja(e) {
    e.preventDefault();
    if (e.target.name == 'devolucion') {
        document.getElementById('title_movimiento').textContent = 'Devolucion de Efectivo de Caja';
        document.getElementById('accion').value = 'devolucion_caja';
    } else if (e.target.name == 'prestamos') {
        document.getElementById('accion').value = 'prestamo_caja';
        document.getElementById('title_movimiento').textContent = 'Prestamo de Efectivo de Caja';
    } else {
        document.getElementById('accion').value = 'gasto_caja';
        document.getElementById('title_movimiento').textContent = 'Gasto de Efectivo de Caja';
    }
    document.getElementById('frmMovimiento').reset();
    $('#movimientos_caja').modal('show');

}

function registrarMovimiento(e) {
    e.preventDefault();
    const monto = document.getElementById('monto').value;
    const desc = document.getElementById('descripcion').value;
    if (monto == '' || desc == '') {
        alertas('Todo los campos con * son requeridos');
        return false;
    } else {
        const url = base_url + 'cajas/registrar_movimiento';
        const frm = document.getElementById('frmMovimiento');
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                if (res.icono == 'success') {
                    grafico_movimiento();
                    $('#movimientos_caja').modal('hide');
                }
                alertas(res.msg, res.icono);
                return false;
            }
        }
    }
}

function grafico_movimiento() {
    if (MyChart) {
        MyChart.destroy();
    }
    const url = base_url + 'cajas/grafico_movimiento';
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {            
            const res = JSON.parse(this.responseText);
            const moneda = res.moneda;
            document.getElementById("monto_inicial").textContent = moneda + '  ' + res.datos;
            document.getElementById("monto_final").textContent = moneda + '  ' + res.monto;
            document.getElementById("devolucion").textContent = moneda + '  ' + res.devolucion;
            document.getElementById("prestamo").textContent = moneda + '  ' + res.prestamo;
            document.getElementById("gasto").textContent = moneda + '  ' + res.gasto;
            document.getElementById("egresos").textContent = moneda + '  ' + res.egresos;
            document.getElementById("saldo").textContent = moneda + '  ' + res.saldo;
            document.getElementById("total").textContent = moneda + '  ' + res.total;

            let ctx = document.getElementById("reporte_movimiento");
            MyChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: ['Monto Inicial', 'Total Ingresos', 'Devoluciones', 'Prestamos', 'Gastos', 'Saldo en la Caja'],
                    datasets: [{
                        data: [res.datos, res.monto, res.devolucion, res.prestamo, res.gasto, res.total],
                        backgroundColor: ['#007bff', '#28a745', '#dc3545', '#ffc107', '#000000', '#8c004b'],
                    }],
                },
            });
        }
    }
}