<?php
class ClientesModel extends Query{

    public function __construct()
    {
        parent::__construct();
    }

  
    public function getNombreCliente(int $idcliente)
    {
        $sql = "SELECT codigo FROM clientes WHERE id='$idcliente'";
        $codigocl = $this->select($sql);
        $codigo_cliente=$codigocl['codigo'];

        $sql = "SELECT codigo,nombre, coord_ultimavisita FROM clientes WHERE codigo = $codigo_cliente";
        $data = $this->select($sql);
        return $data;
    }

    public function getClientes(int $idusuario)
    {
        $sql = "SELECT tipousuario,codigo_vendedor FROM usuarios WHERE id = $idusuario";
        $tipo = $this->select($sql);
        $codigo_vendedor=$tipo['codigo_vendedor'];

        if($tipo['tipousuario'] == 3) {
            $sql = "SELECT *, CONCAT(codigo,' - ',nombre) as codigonombre,DATEDIFF(now(),ultimaventa) as diasdiferencia,DATEDIFF(now(),ultimopago) as diasdiferenciapago,DATEDIFF(now(),programacion) as diasdiferenciaprogramacion,DATEDIFF(now(),ultimavisita) as diasdiferenciavisita FROM clientes WHERE id_vendedor1 = '{$codigo_vendedor}'";
        } else {
            $sql = "SELECT *, CONCAT(codigo,' - ',nombre) as codigonombre,DATEDIFF(now(),ultimaventa) as diasdiferencia,DATEDIFF(now(),ultimopago) as diasdiferenciapago,DATEDIFF(now(),programacion) as diasdiferenciaprogramacion,DATEDIFF(now(),ultimavisita) as diasdiferenciavisita FROM clientes";
        }

        $data = $this->selectAll($sql);
        return $data;
    }

    public function guardarVisita($codcliente,$coords,$id_vendedor1)
    {
        $sql = "UPDATE clientes SET ultimavisita=NOW(),coord_ultimavisita=? WHERE codigo=?";
        $datos = array($coords, $codcliente);
        $data = $this->save($sql, $datos);
        
        $sql = "INSERT INTO `visitas` (`coordenadas`,`codigo`,`id_vendedor`,`fecha`) VALUES (?,?,?,NOW())";
        $datos = array($coords, $codcliente, $id_vendedor1);
        $this->save($sql, $datos);

        $sql = "UPDATE vendedores SET ultimavisita=NOW(),coord_ultimavisita=? WHERE codven=?";
        $datos = array($coords, $id_vendedor1);
        $this->save($sql, $datos);

        return $data;

    }

    public function getCategorias()
    {
        $sql = "SELECT TRIM(`categorias`.`cod_linea`) as `cod_linea`,`categorias`.`categoria` FROM `categorias` ORDER BY `categoria`";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function comparacionClienteCategorias(int $anio, int $idcliente)
    {
   
        $sql = "SELECT codigo FROM clientes WHERE id='$idcliente'";
        $codigocl = $this->select($sql);
        $codigo_cliente=trim($codigocl['codigo']);

        $sql1 = "CREATE TEMPORARY TABLE tmp_ventas_categoria ENGINE=MEMORY 
        SELECT 
            p.idcategoria,
            SUM(fd.cantidad) AS cantidad,
            SUM(fd.total) AS ventas
        FROM `".prefixant."`.facturaenc fe
        INNER JOIN `".prefixant."`.facturadet fd ON fe.numdoc = fd.numdoc
        INNER JOIN `".prefixant."`.productos p ON p.prod_cod = fd.codart
        WHERE TRIM(fe.codcliente) = '{$codigo_cliente}'
            AND YEAR(fe.fechadoc) ={$anio} 
        GROUP BY p.idcategoria";
        $this->select($sql1);

        $sql2 = "SELECT 
            tv.idcategoria,
            TRIM(c.cod_linea) AS cod_linea,
            c.categoria,
            tv.cantidad,
            tv.ventas
        FROM tmp_ventas_categoria tv
        INNER JOIN `".db."`.categorias c ON c.id = tv.idcategoria
        ORDER BY tv.ventas DESC";

        $data = $this->selectAll($sql2);

        $this->select("DROP TEMPORARY TABLE IF EXISTS tmp_ventas_categoria");

        return $data;

        /*$sql = "SELECT `productos`.`idcategoria`, TRIM(`categorias`.`cod_linea`) as `cod_linea`,`categorias`.`categoria`, SUM(`facturadet`.`cantidad`) as cantidad, SUM(`facturadet`.`total`) as ventas FROM `".prefixant."`.`facturadet`
                INNER JOIN `".prefixant."`.`facturaenc` ON `facturaenc`.`numdoc`=`facturadet`.`numdoc`
                INNER JOIN `".prefixant."`.`productos` ON `productos`.`prod_cod`=`facturadet`.`codart`
                INNER JOIN `".db."`.`categorias` ON `categorias`.`id`=`productos`.`idcategoria`
                WHERE trim(`facturaenc`.`codcliente`)='{$codigo_cliente}' AND YEAR(`facturaenc`.`fechadoc`)={$anio}
                GROUP BY `productos`.`idcategoria`";
        $data = $this->selectAll($sql);
                */
    }

    public function comparacionPagos(int $anio, int $idcliente)
    {
        $sql = "SELECT codigo FROM clientes WHERE id='$idcliente'";
        $codigocl = $this->select($sql);
        $codigo_cliente=$codigocl['codigo'];        

        $sql = "SELECT
        r.`rec_id` as id
        ,r.`rec_numero` as numero
        ,r.`rec_fecha` as fecha
        ,r.`rec_abono` as valor
        ,CASE
                WHEN r.`rec_tipo` = 0 THEN 'No seleccionado'
                WHEN r.`rec_tipo` = 1 THEN 'Efectivo'
                WHEN r.`rec_tipo` = 2 THEN 'Cheque'
                WHEN r.`rec_tipo` = 3 THEN 'Deposito'
                WHEN r.`rec_tipo` = 4 THEN 'Otros'
        END AS tipo        
        ,b.`ban_nom` as banco
        ,r.`rec_ref` as referencia
        ,r.`rec_obs` as observaciones
        FROM `".prefixant."`.`recibos` r
        INNER JOIN `".prefixant."`.`bancos` b ON r.`rec_banco`=b.`ban_cod`
        WHERE 
        TRIM(`rec_cod`)=TRIM('{$codigo_cliente}') AND YEAR(r.`rec_fecha`)={$anio}
        ORDER BY fecha DESC";
        
        $data = $this->selectAll($sql);
        return $data;        
    }

    public function comparacionFacturas(int $anio, int $idcliente)
    {
        $sql = "SELECT codigo FROM clientes WHERE id='$idcliente'";
        $codigocl = $this->select($sql);
        $codigo_cliente=$codigocl['codigo'];        

        $sql = "SELECT
        numdoc as numero
        ,DATE(fechadoc) as fecha
        ,total as valor
        ,saldo as saldo
        FROM `".prefixant."`.`facturaenc`
        WHERE 
        estado<>'A' AND YEAR(fechadoc)={$anio} AND TRIM(`codcliente`)=TRIM('{$codigo_cliente}')
        ORDER BY fecha DESC";
        
        $data = $this->selectAll($sql);
        return $data;        
    }

    public function comparacionClienteProductos(int $anio, int $idcliente)
    {
        $sql = "SELECT codigo FROM clientes WHERE id='$idcliente'";
        $codigocl = $this->select($sql);
        $codigo_cliente=$codigocl['codigo'];


        /*$sql = "SELECT `facturadet`.`codart`,`productos`.`idcategoria`, `categorias`.`cod_linea`, `productos`.`prod_descrip`, SUM(`facturadet`.`cantidad`) as cantidad, SUM(`facturadet`.`total`) as ventas
                FROM `".prefixant."`.`facturadet`
                INNER JOIN `".prefixant."`.`facturaenc` ON `facturaenc`.`numdoc`=`facturadet`.`numdoc`
                INNER JOIN `".prefixant."`.`productos` ON `productos`.`prod_cod`=`facturadet`.`codart`
                INNER JOIN `".db."`.`categorias` ON `categorias`.`id`=`productos`.`idcategoria`
                WHERE trim(`facturaenc`.`codcliente`)='{$codigo_cliente}'  AND YEAR(`facturaenc`.`fechadoc`)={$anio}
                GROUP BY `facturadet`.`codart`";
        $data = $this->selectAll($sql);*/

        $sql1 = "CREATE TEMPORARY TABLE tmp_ventas_producto ENGINE=MEMORY
        SELECT 
            fd.codart,
            p.idcategoria,
            p.prod_descrip,
            SUM(fd.cantidad) AS cantidad,
            SUM(fd.total) AS ventas
        FROM `".prefixant."`.facturaenc fe
        INNER JOIN `".prefixant."`.facturadet fd ON fe.numdoc = fd.numdoc
        INNER JOIN `".prefixant."`.productos p ON p.prod_cod = fd.codart
        WHERE TRIM(fe.codcliente) = '{$codigo_cliente}'
            AND YEAR(fe.fechadoc) = {$anio}
        GROUP BY fd.codart, p.idcategoria, p.prod_descrip";
        
        $this->select($sql1);

        $sql2 = "SELECT 
            tv.codart,
            tv.idcategoria,
            c.cod_linea,
            tv.prod_descrip,
            tv.cantidad,
            tv.ventas
        FROM tmp_ventas_producto tv
        INNER JOIN `".db."`.categorias c ON c.id = tv.idcategoria
        ORDER BY tv.ventas DESC";
        
        $data = $this->selectAll($sql2);        

        $this->select("DROP TEMPORARY TABLE IF EXISTS tmp_ventas_producto");        

        return $data;
    }

    public function comparacionClienteDatos(int $anio, int $idcliente)
    {
        $sql = "SELECT codigo FROM clientes WHERE id='$idcliente'";
        $codigocl = $this->select($sql);
        $codigo_cliente=$codigocl['codigo'];

        $sql = "SELECT * FROM clientes WHERE codigo='$codigo_cliente'";
        $data = $this->selectAll($sql);
        return $data;

    }


    public function comparacionVentasMes(string $desde, string $hasta, int $idcliente)
    {

        $sql = "SELECT codigo FROM clientes WHERE id='$idcliente'";
        $codigocl = $this->select($sql);
        $codigo_cliente=$codigocl['codigo'];


        $sql = "SELECT
            COALESCE(SUM(IF(MONTH(`fechadoc`) = 1,  total, 0)),0) AS ene,
            COALESCE(SUM(IF(MONTH(`fechadoc`) = 2,  total, 0)),0) AS feb,
            COALESCE(SUM(IF(MONTH(`fechadoc`) = 3,  total, 0)),0) AS mar,
            COALESCE(SUM(IF(MONTH(`fechadoc`) = 4,  total, 0)),0) AS abr,
            COALESCE(SUM(IF(MONTH(`fechadoc`) = 5,  total, 0)),0) AS may,
            COALESCE(SUM(IF(MONTH(`fechadoc`) = 6,  total, 0)),0) AS jun,
            COALESCE(SUM(IF(MONTH(`fechadoc`) = 7,  total, 0)),0) AS jul,
            COALESCE(SUM(IF(MONTH(`fechadoc`) = 8,  total, 0)),0) AS ago,
            COALESCE(SUM(IF(MONTH(`fechadoc`) = 9,  total, 0)),0) AS sep,
            COALESCE(SUM(IF(MONTH(`fechadoc`) = 10, total, 0)),0) AS oct,
            COALESCE(SUM(IF(MONTH(`fechadoc`) = 11, total, 0)),0) AS nov,
            COALESCE(SUM(IF(MONTH(`fechadoc`) = 12, total, 0)),0) AS dic
        FROM `".prefixant."`.`facturaenc`
        WHERE `fechadoc` BETWEEN '$desde' AND '$hasta' AND codcliente='$codigo_cliente'";        

        $data = $this->select($sql);
        return $data;
    }

    public function comparacionPagosMes(string $desde, string $hasta, int $idcliente)
    {

        $sql = "SELECT codigo FROM clientes WHERE id='$idcliente'";
        $codigocl = $this->select($sql);
        $codigo_cliente=$codigocl['codigo'];

        $sql = "SELECT
            COALESCE(SUM(IF(MONTH(rec_fecha) = 1,  rec_abono, 0)),0) AS ene,
            COALESCE(SUM(IF(MONTH(rec_fecha) = 2,  rec_abono, 0)),0) AS feb,
            COALESCE(SUM(IF(MONTH(rec_fecha) = 3,  rec_abono, 0)),0) AS mar,
            COALESCE(SUM(IF(MONTH(rec_fecha) = 4,  rec_abono, 0)),0) AS abr,
            COALESCE(SUM(IF(MONTH(rec_fecha) = 5,  rec_abono, 0)),0) AS may,
            COALESCE(SUM(IF(MONTH(rec_fecha) = 6,  rec_abono, 0)),0) AS jun,
            COALESCE(SUM(IF(MONTH(rec_fecha) = 7,  rec_abono, 0)),0) AS jul,
            COALESCE(SUM(IF(MONTH(rec_fecha) = 8,  rec_abono, 0)),0) AS ago,
            COALESCE(SUM(IF(MONTH(rec_fecha) = 9,  rec_abono, 0)),0) AS sep,
            COALESCE(SUM(IF(MONTH(rec_fecha) = 10, rec_abono, 0)),0) AS oct,
            COALESCE(SUM(IF(MONTH(rec_fecha) = 11, rec_abono, 0)),0) AS nov,
            COALESCE(SUM(IF(MONTH(rec_fecha) = 12, rec_abono, 0)),0) AS dic
        FROM `".prefixant."`.`recibos`
        WHERE rec_fecha BETWEEN '$desde' AND '$hasta' AND rec_cod='$codigo_cliente'";

        $data = $this->select($sql);
        return $data;
    }

    public function getEmpresa()
    {
        $sql = "SELECT * FROM empresa";
        $data = $this->select($sql);
        return $data;
    }

    public function getVendedoresClientes($idusuario)
    {
        $sql = "SELECT tipousuario,codigo_vendedor FROM usuarios WHERE id = $idusuario";
        $tipo = $this->select($sql);
        $codigo_vendedor=$tipo['codigo_vendedor'];

        if($tipo['tipousuario'] == 3) {
            $sql = "SELECT codven as codigo, vendedores.nombre as vendedor FROM `vendedores` WHERE codven = '{$codigo_vendedor}'";
            //$sql = "SELECT codigo_vendedor as codigo,usuarios.nombre as nombre, vendedores.nombre as vendedor FROM `usuarios` INNER JOIN `vendedores` ON usuarios.codigo_vendedor=vendedores.codven WHERE codigo_vendedor IN (SELECT `id_vendedor1` FROM `clientes` group by `id_vendedor1`) AND codigo_vendedor = $codigo_vendedor";
        } else {
            //$sql = "SELECT codigo_vendedor as codigo,usuarios.nombre as nombre, vendedores.nombre as vendedor FROM `usuarios` INNER JOIN `vendedores` ON usuarios.codigo_vendedor=vendedores.codven WHERE codigo_vendedor IN (SELECT `id_vendedor1` FROM `clientes` group by `id_vendedor1`)";
            $sql = "SELECT codven as codigo, vendedores.nombre as vendedor FROM `vendedores`";
            //$sql = "SELECT codigo_vendedor as codigo,usuarios.nombre as nombre, vendedores.nombre as vendedor FROM `usuarios` INNER JOIN `vendedores` ON usuarios.codigo_vendedor=vendedores.codven WHERE codigo_vendedor IN (SELECT `id_vendedor1` FROM `clientes` group by `id_vendedor1`)";
        }

        $data = $this->selectAll($sql);
        return $data;
    }
    
    public function getVisitasMes($anio, $cliente)
    {
        $sql = "SELECT codigo FROM clientes WHERE id='$cliente'";
        $codigocl = $this->select($sql);
        $codigo_cliente=$codigocl['codigo'];

        $sql = "SELECT * FROM visitas WHERE YEAR(fecha) = $anio AND codigo = '{$codigo_cliente}' ORDER BY fecha";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function getVisitasMesGroup($anio, $cliente)
    {

        $sql = "SELECT codigo FROM clientes WHERE id='$cliente'";
        $codigocl = $this->select($sql);
        $codigo_cliente=$codigocl['codigo'];


        $sql = "SELECT
            COALESCE(SUM(IF(MONTH(fecha) = 1,  1, 0)),0) AS ene,
            COALESCE(SUM(IF(MONTH(fecha) = 2,  1, 0)),0) AS feb,
            COALESCE(SUM(IF(MONTH(fecha) = 3,  1, 0)),0) AS mar,
            COALESCE(SUM(IF(MONTH(fecha) = 4,  1, 0)),0) AS abr,
            COALESCE(SUM(IF(MONTH(fecha) = 5,  1, 0)),0) AS may,
            COALESCE(SUM(IF(MONTH(fecha) = 6,  1, 0)),0) AS jun,
            COALESCE(SUM(IF(MONTH(fecha) = 7,  1, 0)),0) AS jul,
            COALESCE(SUM(IF(MONTH(fecha) = 8,  1, 0)),0) AS ago,
            COALESCE(SUM(IF(MONTH(fecha) = 9,  1, 0)),0) AS sep,
            COALESCE(SUM(IF(MONTH(fecha) = 10, 1, 0)),0) AS oct,
            COALESCE(SUM(IF(MONTH(fecha) = 11, 1, 0)),0) AS nov,
            COALESCE(SUM(IF(MONTH(fecha) = 12, 1, 0)),0) AS dic
        FROM visitas WHERE YEAR(fecha) = $anio AND codigo = '{$codigo_cliente}' GROUP BY MONTH(fecha)";

        $data = $this->selectAll($sql);
        return $data;
    }

    public function getVendedores()
    {
        $sql = "SELECT codven, nombre FROM vendedores";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getReporteCuentasCobrar($id)
    {

        $sql = "SELECT codigo FROM clientes WHERE id='$id'";
        $codigocl = $this->select($sql);
        $codigo_cliente=$codigocl['codigo'];

        if((int)$id!==0) {
                $sql = "SELECT
                    IFNULL((SELECT clientes.nombre FROM `".db."`.`clientes` WHERE clientes.id=creditos.codcliente), 'MOSTRADOR') AS CLIENTE,
                    IF(creditos.codcliente=0, 1, creditos.codcliente) AS IDCLIENTE,
                    `creditos`.`numdoc` as FACTURA,
                    DATE(`creditos`.`fechadoc`) as FECHA,
                    `creditos`.`total` as VALOR,
                    `creditos`.`total`-`creditos`.`saldo` as ABONO,
                    `creditos`.`saldo` as SALDO,
                    DATEDIFF(NOW(), DATE(`creditos`.`fechadoc`)) AS DIAS_DE_ATRASO
                    FROM `".prefixant."`.`facturaenc` creditos
                    WHERE creditos.codcliente='".addslashes($codigo_cliente)."'
                    AND `creditos`.`saldo` > 0
                    ORDER BY FACTURA ASC";

        } else {
                    $sql = "SELECT
                    IFNULL((SELECT clientes.nombre FROM `".db."`.`clientes` WHERE clientes.id=creditos.codcliente), 'MOSTRADOR') AS CLIENTE,
                    IF(creditos.codcliente=0, 1, creditos.codcliente) AS IDCLIENTE,
                    `creditos`.`numdoc` as FACTURA,
                    DATE(`creditos`.`fechadoc`) as FECHA,
                    `creditos`.`total` as VALOR,
                    `creditos`.`total`-`creditos`.`saldo` as ABONO,
                    `creditos`.`saldo` as SALDO,
                    DATEDIFF(NOW(), DATE(`creditos`.`fechadoc`)) AS DIAS_DE_ATRASO
                    FROM `".prefixant."`.`facturaenc` creditos
                    WHERE `creditos`.`saldo` > 0
                    ORDER BY IDCLIENTE,FACTURA ASC";
        }
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getReporteAntiguedadSaldos($id)
    {

        $sql = "SELECT codigo FROM clientes WHERE id='$id'";
        $codigocl = $this->select($sql);
        $codigo_cliente=$codigocl['codigo'];

        if((int)$id!==0) {

                    $sql = "SELECT 
                    IFNULL((SELECT clientes.nombre FROM `".db."`.`clientes` WHERE clientes.id=creditos.codcliente), 'MOSTRADOR') AS CLIENTE,
                    IF(creditos.codcliente=0, 1, creditos.codcliente) AS IDCLIENTE,
                    `creditos`.`numdoc` as FACTURA,
                    DATE(`creditos`.`fechadoc`) as FECHA,
                    DATE_ADD(DATE(`creditos`.`fechadoc`), INTERVAL 30 DAY) as VENCE,
                    `creditos`.`total` as VALOR,
                    `creditos`.`saldo` as SALDO,
                    DATEDIFF(NOW(), DATE(`creditos`.`fechadoc`)) AS DIAS_DE_ATRASO,
                    IF(DATEDIFF(NOW(), DATE(`creditos`.`fechadoc`))<=30, (`creditos`.`saldo`), 0) as '30',
                    IF(DATEDIFF(NOW(), DATE(`creditos`.`fechadoc`))>30 && DATEDIFF(NOW(), DATE(`creditos`.`fechadoc`))<=60, (`creditos`.`saldo`), 0) as '60',
                    IF(DATEDIFF(NOW(), DATE(`creditos`.`fechadoc`))>60, (`creditos`.`saldo`), 0) as '90'
                    FROM `".prefixant."`.`facturaenc` creditos
                    WHERE creditos.codcliente='".addslashes($codigo_cliente)."'
                    AND `creditos`.`saldo` > 0
                    ORDER BY FACTURA ASC";

        } else {

                $sql = "SELECT 
                IFNULL((SELECT clientes.nombre FROM `".db."`.`clientes` WHERE clientes.id=creditos.codcliente), 'MOSTRADOR') AS CLIENTE,
                IF(creditos.codcliente=0, 1, creditos.codcliente) AS IDCLIENTE,
                `creditos`.`numdoc` as FACTURA,
                DATE(`creditos`.`fechadoc`) as FECHA,
                DATE_ADD(DATE(`creditos`.`fechadoc`), INTERVAL 30 DAY) as VENCE,
                `creditos`.`total` as VALOR,
                `creditos`.`saldo` as SALDO,
                DATEDIFF(NOW(), DATE(`creditos`.`fechadoc`)) AS DIAS_DE_ATRASO,
                IF(DATEDIFF(NOW(), DATE(`creditos`.`fechadoc`))<=30, (`creditos`.`saldo`), 0) as '30',
                IF(DATEDIFF(NOW(), DATE(`creditos`.`fechadoc`))>30 && DATEDIFF(NOW(), DATE(`creditos`.`fechadoc`))<=60, (`creditos`.`saldo`), 0) as '60',
                IF(DATEDIFF(NOW(), DATE(`creditos`.`fechadoc`))>60, (`creditos`.`saldo`), 0) as '90'
                FROM `".prefixant."`.`facturaenc` creditos
                WHERE `creditos`.`saldo` > 0
                ORDER BY IDCLIENTE,FACTURA ASC";
        }
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getReporteEstadoCuenta($id)
    {
        $sql = "SELECT codigo FROM clientes WHERE id='$id'";
        $codigocl = $this->select($sql);
        $codigo_cliente=$codigocl['codigo'];
        
        $sql = "(SELECT 
                venta as DOCUMENTO
                ,venta as ORDERDOCUMENTO
                ,fecha as FECHA
                ,monto as CARGO
                ,0 as ABONO
                ,'' as REFERENCIA
                FROM `creditos` WHERE cliente='".addslashes($codigo_cliente)."')
                UNION 
                (SELECT
                (SELECT concat(creditos.venta,' - R.',abonos.id) FROM `creditos` WHERE creditos.id=abonos.id_credito LIMIT 1) as DOCUMENTO
                ,(SELECT venta FROM `creditos` WHERE creditos.id=abonos.id_credito LIMIT 1) as ORDERDOCUMENTO
                ,fecha_abono as FECHA
                ,0 as CARGO
                ,monto * -1 as ABONO
                , CONCAT(metodo_pago,' | ',observaciones,' | ',referencias) as REFERENCIA
                FROM `abonos` WHERE id_cliente='".addslashes($id)."')
                ORDER BY ORDERDOCUMENTO, FECHA";

        $data = $this->selectAll($sql);
        return $data;
    }    


    public function getPaises()
    {
        $sql = "SELECT cod, pais FROM paises";
        $data = $this->selectAll($sql);
        return $data;
    }
    
    public function registrarCliente(string $nombre, int $tipoid,string $nit, string $telefono, string $mensajeria, string $direccion, string $municipio, string $departamento, string $pais, string $coordenadas, float $limite_credito, int $dias_credito, int $id_vendedor1, int $tipocliente, string $contacto, string $telcontacto, string $observaciones)
    {
        $verficar = "SELECT * FROM clientes WHERE nombre = '$nombre'";
        $existe = $this->select($verficar);
        if (empty($existe)) {
            $sql = "INSERT INTO clientes(nombre, tipoid, nit, telefono, mensajeria, direccion, municipio, departamento, pais, coordenadas, limite_credito, dias_credito, id_vendedor1, tipocliente ,contacto, telcontacto, observaciones) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            $datos = array($nombre, $tipoid, $nit, $telefono, $mensajeria, $direccion, $municipio, $departamento, $pais, $coordenadas, $limite_credito, $dias_credito, $id_vendedor1, $tipocliente, $contacto, $telcontacto, $observaciones);
            $data = $this->save($sql, $datos);
            if ($data == 1) {
                $res = "ok";
            }else{
                $res = "error";
            }
        }else{
            $res = "existe";
        }
        return $res;
    }


    public function modificarCliente(string $nombre, int $tipoid, string $nit, string $telefono, string $mensajeria, string $direccion, string $municipio, string $departamento, string $pais, string $coordenadas, float $limite_credito, int $dias_credito, int $id_vendedor1, int $tipocliente, string $contacto, string $telcontacto, string $observaciones, int $id)
    {
        $sql = "UPDATE clientes SET nombre = ?, tipoid = ?, nit = ? ,telefono = ? ,mensajeria = ? ,direccion = ? ,municipio = ? ,departamento = ? ,pais = ? ,coordenadas = ? ,limite_credito = ? ,dias_credito = ?, id_vendedor1 = ?, tipocliente = ?, contacto = ?, telcontacto = ?, observaciones = ? WHERE id = ?";
        $datos = array($nombre, $tipoid, $nit, $telefono ,$mensajeria ,$direccion, $municipio, $departamento, $pais, $coordenadas, $limite_credito, $dias_credito, $id_vendedor1, $tipocliente, $contacto, $telcontacto, $observaciones, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "modificado";
        } else {
            $res = "error";
        }
        return $res;
    }

    public function modificarAnotacionesVisitas(string $observaciones, int $id, string $coordenadas)
    {
        $sql = "SELECT TRIM(codigo) AS codigo FROM clientes WHERE id = $id";
        $codigo = $this->select($sql);

        $sql = "UPDATE `visitas` SET `fecha_salida`=NOW(),`coordenadas_salida`=?,`anotaciones`=? WHERE `codigo`=? AND `fecha_salida` IS NULL ORDER BY `id` DESC LIMIT 1";

        $datos = array($coordenadas, $observaciones, $codigo['codigo']);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "modificado";
        } else {
            $res = "error";
        }
        return $res;
    }

    public function modificarAnotaciones(string $observaciones, int $id)
    {
        $sql = "UPDATE clientes SET observaciones = ? WHERE id = ?";
        $datos = array($observaciones, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "modificado";
        } else {
            $res = "error";
        }
        return $res;
    }

    public function modificarProgramacion(string $fecha,int $orden, int $id,$codcliente,$nomcliente,$id_vendedor1)
    {
        $sql = "SELECT TRIM(codigo) AS codigo FROM clientes WHERE id = $id";
        $codigo = $this->select($sql);
        //$codigo['codigo'];

        $sql = "UPDATE clientes SET programacion = ?, orden_programacion = ? WHERE id = ?";
        $datos = array($fecha,$orden, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "modificado";
        } else {
            $res = "error";
        }

        $sql = "INSERT INTO `programaciones` (`codigo`,`id_vendedor`,`fecha`,`fecha_asignacion`) VALUES (?,?,?,now())";
        //$datos = array($id, $id_vendedor1, $fecha);
        $datos = array($codigo['codigo'], $id_vendedor1, $fecha);
        $this->save($sql, $datos);

        $tituloevento='['.$codcliente.']-'.$nomcliente;
        $sql = "INSERT INTO `eventos` (`title`,`descripcion`,`color`,`textColor`,`destinatario`,`start`,`end`) VALUES (?,'Programacion de Visita a Cliente','green','white',?,?,?)";
        $datos = array($tituloevento, $id_vendedor1, $fecha, $fecha);
        $this->save($sql, $datos);


        return $res;

    }

    public function modificarCobro(string $fecha, int $id,$codcliente,$nomcliente,$id_vendedor1)
    {
      /*  $sql = "UPDATE clientes SET programacion = ? WHERE id = ?";
        $datos = array($fecha, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "modificado";
        } else {
            $res = "error";
        }

        $sql = "INSERT INTO `programaciones` (`codigo`,`id_vendedor`,`fecha`,`fecha_asignacion`) VALUES (?,?,?,now())";
        $datos = array($id, $id_vendedor1, $fecha);
        $this->save($sql, $datos); */

        $tituloevento='['.$codcliente.']-'.$nomcliente;
        $sql = "INSERT INTO `eventos` (`title`,`descripcion`,`color`,`textColor`,`destinatario`,`start`,`end`) VALUES (?,'Programacion de Cobro a Cliente','orange','white',?,?,?)";
        $datos = array($tituloevento, $id_vendedor1, $fecha, $fecha);
        $this->save($sql, $datos);


        return $res;

    }

    public function modificarLlamada(string $fecha, int $id,$codcliente,$nomcliente,$id_vendedor1)
    {
        /*$sql = "UPDATE clientes SET programacion = ? WHERE id = ?";
        $datos = array($fecha, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "modificado";
        } else {
            $res = "error";
        }

        $sql = "INSERT INTO `programaciones` (`codigo`,`id_vendedor`,`fecha`,`fecha_asignacion`) VALUES (?,?,?,now())";
        $datos = array($id, $id_vendedor1, $fecha);
        $this->save($sql, $datos);*/

        $tituloevento='['.$codcliente.']-'.$nomcliente;
        $sql = "INSERT INTO `eventos` (`title`,`descripcion`,`color`,`textColor`,`destinatario`,`start`,`end`) VALUES (?,'Programacion de Llamada a Cliente','HotPink','white',?,?,?)";
        $datos = array($tituloevento, $id_vendedor1, $fecha, $fecha);
        $this->save($sql, $datos);


        return $res;

    }

    public function verficarFacturasVencidas(int $id,int $dias_credito)
    {
        $sql = "SELECT count(*) as counter FROM `".prefixant."`.`facturaenc`
        WHERE 
        TRIM(`codcliente`)=TRIM('{$id}')
        AND saldo>0
        AND DATEDIFF(CURDATE(), fechadoc) > {$dias_credito}
        AND estado<>'A'";
        $data = $this->select($sql);
        return $data['counter'];
    }

  

    public function editarCli(int $id)
    {
        $sql = "SELECT * FROM clientes WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }

    public function ultimaVisita(int $id)
    {
        $sql = "SELECT * FROM visitas WHERE codigo = $id ORDER BY id DESC LIMIT 1";
        $data = $this->select($sql);
        return $data;
    }

    public function accionCli(int $estado, int $id)
    {
        $sql = "UPDATE clientes SET estado = ? WHERE id = ?";
        $datos = array($estado, $id);
        $data = $this->save($sql, $datos);
        return $data;
    }

    public function buscarCliente(string $nombre)
    {
        $sql = "SELECT * FROM clientes WHERE (nombre LIKE '%" . $nombre . "%' OR telefono LIKE '%" . $nombre . "%' OR nit LIKE '%" . $nombre . "%') AND estado = 1 LIMIT 10";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getVisitas(string $nombre)
    {
        $sql = "SELECT * FROM visitas";
        $data = $this->selectAll($sql);
        return $data;
    }


}
